---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-ThriftServer Session Detail（ThriftServerセッション詳細）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerSessionPage.scala`（118行）
- E-02: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerPage.scala`（443行）
- E-03: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2AppStatusStore.scala`（133行）
- E-04: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerTab.scala`（54行）
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/sqlserver/session/?id={sessionId}` | E-01 (31行目: `WebUIPage("session")`), E-04 (31行目: prefix "sqlserver") | ○ |
| C-02 | idパラメータは必須 | E-01 (37-38行目: `require(parameterId != null && parameterId.nonEmpty)`) | ○ |
| C-03 | セッション未存在時はrequireエラー | E-01 (41-42行目: `store.getSession(parameterId).orNull`, `require(sessionStat != null)`) | ○ |
| C-04 | 基本情報にStarted at, Time since startを表示 | E-01 (58-68行目: `generateBasicStats`) | ○ |
| C-05 | セッション概要にUser, IP, Session created at, Total run SQLを表示 | E-01 (47-51行目) | ○ |
| C-06 | SQL統計テーブルはセッションIDでフィルタリング | E-01 (72-73行目: `store.getExecutionList.filter(_.sessionId == sessionID)`) | ○ |
| C-07 | SqlStatsPagedTableのsubPathは"sqlserver/session" | E-01 (87行目) | ○ |
| C-08 | テーブルタグは"sqlsessionstat" | E-01 (77行目: `val sqlTableTag = "sqlsessionstat"`) | ○ |
| C-09 | ページタイトルは"JDBC/ODBC Session" | E-01 (54行目: `UIUtils.headerSparkPage(request, "JDBC/ODBC Session"...)`) | ○ |
| C-10 | store.synchronizedでデータ一貫性保証 | E-01 (40行目) | ○ |
| C-11 | テーブルヘッダタイトルは"SQL Statistics" | E-01 (109行目: `<a>SQL Statistics</a>`) | ○ |
| C-12 | SQL実行が0件の場合"No statistics have been generated yet."を表示 | E-01 (113行目) | ○ |
| C-13 | テーブルレンダリングエラー時にアラートdivで表示 | E-01 (92-98行目) | ○ |
| C-14 | ThriftServer版ではIPアドレスが表示される（Connect版と異なる） | E-01 (48行目: `sessionStat.ip`), E-03 (84行目: SessionInfoにipフィールドあり) | ○ |
| C-15 | 画面遷移元はThriftServer Overview | E-05 (ThriftOverview --> ThriftSessionDetail) | ○ |
| C-16 | SqlStatsPagedTableはThriftServerPage.scalaで定義されたものを再利用 | E-02 (165行目: `class SqlStatsPagedTable`), E-01 (83行目: `new SqlStatsPagedTable`) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] Connect版（No.21）との差異（IP表示、テーブルヘッダ名等）が正確に記載されているか確認
- [ ] SqlStatsPagedTableの再利用関係が正しいか確認
